/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WolfToken;
import mage.game.stack.Spell;

class FaldornDreadWolfHeraldTriggeredAbility
extends TriggeredAbilityImpl {
    FaldornDreadWolfHeraldTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new WolfToken()));
        this.setTriggerPhrase("Whenever you cast a spell from exile or a land you control enters from exile, ");
    }

    private FaldornDreadWolfHeraldTriggeredAbility(FaldornDreadWolfHeraldTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FaldornDreadWolfHeraldTriggeredAbility copy() {
        return new FaldornDreadWolfHeraldTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                EntersTheBattlefieldEvent eEvent = (EntersTheBattlefieldEvent)event;
                return eEvent.getFromZone() == Zone.EXILED && eEvent.getTarget().isLand(game);
            }
            case SPELL_CAST: {
                return Optional.ofNullable(game.getSpell(event.getTargetId())).map(Spell::getFromZone).filter(arg_0 -> ((Zone)Zone.EXILED).match(arg_0)).isPresent();
            }
        }
        return false;
    }
}

