/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.MadnessAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class FalkenrathGorgerEffect
extends ContinuousEffectImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("Vampire creature card you own");
    Map<UUID, MadnessAbility> madnessAbilities = new HashMap<UUID, MadnessAbility>();

    public FalkenrathGorgerEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each Vampire creature card you own that isn't on the battlefield has madness. The madness cost is equal to its mana cost";
    }

    private FalkenrathGorgerEffect(FalkenrathGorgerEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.madnessAbilities.putAll(effect.madnessAbilities);
    }

    public FalkenrathGorgerEffect copy() {
        return new FalkenrathGorgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashMap<UUID, MadnessAbility> usedMadnessAbilities = new HashMap<UUID, MadnessAbility>();
        for (Card card : controller.getHand().getCards((FilterCard)filter, game)) {
            this.addMadnessToCard(game, card, usedMadnessAbilities);
        }
        for (Card card : controller.getGraveyard().getCards((FilterCard)filter, game)) {
            this.addMadnessToCard(game, card, usedMadnessAbilities);
        }
        for (Card card : game.getExile().getCardsOwned((FilterCard)filter, controller.getId(), source, game)) {
            this.addMadnessToCard(game, card, usedMadnessAbilities);
        }
        this.madnessAbilities.clear();
        this.madnessAbilities.putAll(usedMadnessAbilities);
        return true;
    }

    private void addMadnessToCard(Game game, Card card, Map<UUID, MadnessAbility> usedMadnessAbilities) {
        MadnessAbility ability = this.madnessAbilities.get(card.getId());
        if (ability == null) {
            ability = new MadnessAbility(card.getSpellAbility().getManaCosts());
        }
        game.getState().addOtherAbility(card, (Ability)ability, false);
        usedMadnessAbilities.put(card.getId(), ability);
    }

    static {
        filter.add((Predicate)SubType.VAMPIRE.getPredicate());
    }
}

