/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FallOfTheImpostorEffect
extends OneShotEffect {
    FallOfTheImpostorEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile a creature with the greatest power among creatures target opponent controls";
    }

    private FallOfTheImpostorEffect(FallOfTheImpostorEffect effect) {
        super((OneShotEffect)effect);
    }

    public FallOfTheImpostorEffect copy() {
        return new FallOfTheImpostorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, opponent.getId(), game);
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                permanent = (Permanent)permanents.get(0);
                break;
            }
            default: {
                int power = permanents.stream().map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(Integer.MIN_VALUE);
                FilterCreaturePermanent filter = new FilterCreaturePermanent();
                filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
                filter.add((Predicate)new PowerPredicate(ComparisonType.OR_GREATER, power));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                controller.chooseTarget(this.outcome, (Target)target, source, game);
                permanent = game.getPermanent(target.getFirstTarget());
            }
        }
        return permanent != null && controller.moveCards((Card)permanent, Zone.EXILED, source, game);
    }
}

