/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class FallOfTheThranReturnEffect
extends OneShotEffect {
    FallOfTheThranReturnEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "each player returns two land cards from their graveyard to the battlefield";
    }

    private FallOfTheThranReturnEffect(FallOfTheThranReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public FallOfTheThranReturnEffect copy() {
        return new FallOfTheThranReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        LinkedHashMap<UUID, Set> toBattlefield = new LinkedHashMap<UUID, Set>();
        if (controller != null) {
            Player player;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(2, 2, (FilterCard)StaticFilters.FILTER_CARD_LAND);
                target.withNotTarget(true);
                target.setTargetController(playerId);
                if (!target.canChoose(playerId, source, game)) continue;
                player.choose(this.outcome, (Target)target, source, game);
                if (target.getTargets().size() != 2) continue;
                toBattlefield.put(playerId, new CardsImpl((Collection)target.getTargets()).getCards(game));
            }
            for (Map.Entry entry : toBattlefield.entrySet()) {
                player = game.getPlayer((UUID)entry.getKey());
                if (player == null) continue;
                player.moveCards((Set)entry.getValue(), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

