/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FalseCureTriggeredAbility
extends DelayedTriggeredAbility {
    FalseCureTriggeredAbility() {
        super((Effect)new LoseLifeTargetEffect(0), Duration.EndOfTurn, false);
    }

    private FalseCureTriggeredAbility(FalseCureTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public FalseCureTriggeredAbility copy() {
        return new FalseCureTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAINED_LIFE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        this.getEffects().clear();
        LoseLifeTargetEffect effect = new LoseLifeTargetEffect(2 * event.getAmount());
        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        this.addEffect((Effect)effect);
        return true;
    }

    public String getRule() {
        return "Until end of turn, whenever a player gains life, that player loses 2 life for each 1 life they gained.";
    }
}

