/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.HumanSoldierToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.watchers.common.PlayersAttackedThisTurnWatcher;

class FaramirPrinceOfIthilienDelayedEffect
extends OneShotEffect {
    FaramirPrinceOfIthilienDelayedEffect() {
        super(Outcome.Benefit);
        this.staticText = "you draw a card if the chosen player didn't attack you that turn. Otherwise, create three 1/1 white Human Soldier creature tokens.";
    }

    private FaramirPrinceOfIthilienDelayedEffect(FaramirPrinceOfIthilienDelayedEffect effect) {
        super((OneShotEffect)effect);
    }

    public FaramirPrinceOfIthilienDelayedEffect copy() {
        return new FaramirPrinceOfIthilienDelayedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PlayersAttackedThisTurnWatcher watcher = (PlayersAttackedThisTurnWatcher)game.getState().getWatcher(PlayersAttackedThisTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        UUID controllerId = source.getControllerId();
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        if (watcher.hasPlayerAttackedPlayer(targetId, controllerId)) {
            return new CreateTokenEffect((Token)new HumanSoldierToken(), 3).apply(game, source);
        }
        return new DrawCardSourceControllerEffect(1).apply(game, source);
    }
}

