/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FaramirPrinceOfIthilienDelayedEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.Watcher;
import mage.watchers.common.PlayersAttackedThisTurnWatcher;

class FaramirPrinceOfIthilienEffect
extends OneShotEffect {
    FaramirPrinceOfIthilienEffect() {
        super(Outcome.Neutral);
        this.staticText = "choose an opponent. At the beginning of that player's next end step, you draw a card if they didn't attack you that turn. Otherwise, create three 1/1 white Human Soldier creature tokens.";
    }

    private FaramirPrinceOfIthilienEffect(FaramirPrinceOfIthilienEffect effect) {
        super((OneShotEffect)effect);
    }

    public FaramirPrinceOfIthilienEffect copy() {
        return new FaramirPrinceOfIthilienEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent(true);
        target.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        FaramirPrinceOfIthilienDelayedEffect effect = new FaramirPrinceOfIthilienDelayedEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId(), game));
        AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility delayed = new AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility((Effect)effect, opponent.getId());
        delayed.addWatcher((Watcher)new PlayersAttackedThisTurnWatcher());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayed, source);
        return true;
    }
}

