/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class FastingReplacementEffect
extends ReplacementEffectImpl {
    FastingReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If you would begin your draw step, you may skip that step instead. If you do, you gain 2 life";
    }

    private FastingReplacementEffect(FastingReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FastingReplacementEffect copy() {
        return new FastingReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_STEP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (event.getPlayerId().equals(source.getControllerId()) && controller != null && controller.chooseUse(this.outcome, "Skip your draw step to gain 2 life?", source, game)) {
            controller.gainLife(2, game, source);
            return true;
        }
        return false;
    }
}

