/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class FateTransferEffect
extends OneShotEffect {
    FateTransferEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Move all counters from target creature onto another target creature";
    }

    private FateTransferEffect(FateTransferEffect effect) {
        super((OneShotEffect)effect);
    }

    public FateTransferEffect copy() {
        return new FateTransferEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creatureToMoveCountersFrom = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent creatureToMoveCountersTo = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (creatureToMoveCountersFrom != null && creatureToMoveCountersTo != null) {
            Permanent copyCreature = creatureToMoveCountersFrom.copy();
            for (Counter counter : copyCreature.getCounters(game).values()) {
                creatureToMoveCountersFrom.removeCounters(counter, source, game);
                creatureToMoveCountersTo.addCounters(counter, source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

