/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FatefulAbsenceEffect
extends OneShotEffect {
    FatefulAbsenceEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature or planeswalker. Its controller investigates";
    }

    private FatefulAbsenceEffect(FatefulAbsenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public FatefulAbsenceEffect copy() {
        return new FatefulAbsenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        UUID controllerId = permanent.getControllerId();
        permanent.destroy(source, game, false);
        new InvestigateTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(controllerId)).apply(game, source);
        return true;
    }
}

