/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FatespinnerSkipEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FatespinnerChooseEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    public FatespinnerChooseEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player chooses draw step, main phase, or combat phase. The player skips each instance of the chosen step or phase this turn.";
    }

    private FatespinnerChooseEffect(FatespinnerChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public FatespinnerChooseEffect copy() {
        return new FatespinnerChooseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose phase or step to skip");
            choice.setChoices(choices);
            if (!player.choose(this.outcome, (Choice)choice, game)) {
                return false;
            }
            String chosenPhase = choice.getChoice();
            game.informPlayers(player.getLogName() + " has chosen to skip " + chosenPhase.toLowerCase(Locale.ENGLISH) + '.');
            game.addEffect((ContinuousEffect)new FatespinnerSkipEffect(chosenPhase), source);
            return true;
        }
        return false;
    }

    static {
        choices.add("Draw step");
        choices.add("Main phase");
        choices.add("Combat phase");
    }
}

