/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Iterator;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FathomTrawlEffect
extends OneShotEffect {
    FathomTrawlEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal cards from the top of your library until you reveal three nonland cards. Put the nonland cards revealed this way into your hand, then put the rest of the revealed cards on the bottom of your library in any order";
    }

    private FathomTrawlEffect(FathomTrawlEffect effect) {
        super((OneShotEffect)effect);
    }

    public FathomTrawlEffect copy() {
        return new FathomTrawlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        CardsImpl nonlandCards = new CardsImpl();
        CardsImpl landCards = new CardsImpl();
        Iterator iterator = controller.getLibrary().getCards(game).iterator();
        while (iterator.hasNext() && (card = (Card)iterator.next()) != null) {
            cards.add(card);
            if (!card.isLand(game)) {
                nonlandCards.add(card);
                if (nonlandCards.size() != 3) continue;
                break;
            }
            landCards.add(card);
        }
        controller.revealCards(sourceObject.getName(), (Cards)cards, game);
        controller.moveCards((Cards)nonlandCards, Zone.HAND, source, game);
        controller.putCardsOnBottomOfLibrary((Cards)landCards, game, source, true);
        return true;
    }
}

