/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class FaultLineEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public FaultLineEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to each creature without flying and each player";
    }

    private FaultLineEffect(FaultLineEffect effect) {
        super((OneShotEffect)effect);
    }

    public FaultLineEffect copy() {
        return new FaultLineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            permanent.damage(amount, source.getSourceId(), source, game, false, true);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.damage(amount, source.getSourceId(), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

