/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FavorOfTheMightyEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("all colors");

    FavorOfTheMightyEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each creature with the greatest mana value has protection from each color.";
    }

    private FavorOfTheMightyEffect(FavorOfTheMightyEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public FavorOfTheMightyEffect copy() {
        return new FavorOfTheMightyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int maxCMC = Integer.MIN_VALUE;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            if (permanent == null || permanent.getManaValue() <= maxCMC) continue;
            maxCMC = permanent.getManaValue();
        }
        FilterCreaturePermanent filterMaxCMC = new FilterCreaturePermanent();
        filterMaxCMC.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, maxCMC));
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterMaxCMC, source.getControllerId(), game)) {
            if (permanent == null) continue;
            permanent.addAbility((Ability)new ProtectionAbility((Filter)filter), source.getSourceId(), game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{new ColorPredicate(ObjectColor.WHITE), new ColorPredicate(ObjectColor.BLUE), new ColorPredicate(ObjectColor.BLACK), new ColorPredicate(ObjectColor.RED), new ColorPredicate(ObjectColor.GREEN)}));
    }
}

