/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class FblthpTheLostWatcher
extends Watcher {
    private final Set<MageObjectReference> spellsCastFromLibrary = new HashSet<MageObjectReference>();

    FblthpTheLostWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.getZone() == Zone.LIBRARY && (spell = (Spell)game.getObject(event.getTargetId())) != null) {
            this.spellsCastFromLibrary.add(new MageObjectReference((MageObject)spell, game));
        }
    }

    boolean spellWasCastFromLibrary(MageObjectReference mor) {
        return this.spellsCastFromLibrary.contains(mor);
    }

    public void reset() {
        super.reset();
        this.spellsCastFromLibrary.clear();
    }
}

