/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FealtyToTheRealmEffect
extends ContinuousEffectImpl {
    FealtyToTheRealmEffect() {
        super(Duration.WhileOnBattlefield, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.staticText = "the monarch controls enchanted creature";
    }

    private FealtyToTheRealmEffect(FealtyToTheRealmEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public FealtyToTheRealmEffect copy() {
        return new FealtyToTheRealmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentIfItStillExists(game);
        if (enchantment == null || game.getMonarchId() == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        permanent.changeControllerId(game.getMonarchId(), game, source);
        return true;
    }
}

