/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FeatherTheRedeemedEffect
extends ReplacementEffectImpl {
    private final MageObjectReference morSpell;
    private final MageObjectReference morCard;

    FeatherTheRedeemedEffect(Spell spell, Game game) {
        super(Duration.OneUse, Outcome.Benefit);
        this.morSpell = new MageObjectReference((MageObject)spell.getCard(), game);
        this.morCard = new MageObjectReference((MageObject)spell.getMainCard(), game);
    }

    private FeatherTheRedeemedEffect(FeatherTheRedeemedEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.morSpell = effect.morSpell;
        this.morCard = effect.morCard;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Spell sourceSpell = this.morSpell.getSpell(game);
        if (sourceSpell == null || sourceSpell.isCopy()) {
            return false;
        }
        Player player = game.getPlayer(sourceSpell.getOwnerId());
        if (player == null) {
            return false;
        }
        OneShotEffect effect = new ReturnToHandTargetEffect().setText("return " + sourceSpell.getName() + " to its owner's hand");
        player.moveCards((Card)sourceSpell, Zone.EXILED, source, game);
        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return Zone.STACK.equals((Object)zEvent.getFromZone()) && Zone.GRAVEYARD.equals((Object)zEvent.getToZone()) && this.morSpell.refersTo(event.getSourceId(), game) && this.morCard.refersTo(event.getTargetId(), game);
    }

    public FeatherTheRedeemedEffect copy() {
        return new FeatherTheRedeemedEffect(this);
    }
}

