/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.f.FeatherTheRedeemedEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;

class FeatherTheRedeemedTriggeredAbility
extends TriggeredAbilityImpl {
    FeatherTheRedeemedTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private FeatherTheRedeemedTriggeredAbility(FeatherTheRedeemedTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FeatherTheRedeemedTriggeredAbility copy() {
        return new FeatherTheRedeemedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        SpellAbility sa = spell.getSpellAbility();
        for (UUID modeId : sa.getModes().getSelectedModes()) {
            Permanent permanent;
            Mode mode = sa.getModes().get((Object)modeId);
            for (Target target : mode.getTargets()) {
                for (UUID targetId : target.getTargets()) {
                    permanent = game.getPermanent(targetId);
                    if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(this.getControllerId())) continue;
                    this.getEffects().clear();
                    this.addEffect((Effect)new FeatherTheRedeemedEffect(spell, game));
                    return true;
                }
            }
            for (Effect effect : mode.getEffects()) {
                for (UUID targetId : effect.getTargetPointer().getTargets(game, (Ability)sa)) {
                    permanent = game.getPermanent(targetId);
                    if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(this.getControllerId())) continue;
                    this.getEffects().clear();
                    this.addEffect((Effect)new FeatherTheRedeemedEffect(spell, game));
                    return true;
                }
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell that targets a creature you control, exile that card instead of putting it into your graveyard as it resolves. If you do, return it to your hand at the beginning of the next end step.";
    }
}

