/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FecundGreenshellEffect
extends OneShotEffect {
    FecundGreenshellEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield tapped. Otherwise, put it into your hand";
    }

    private FecundGreenshellEffect(FecundGreenshellEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top card of library", card, game);
        if (card.isLand(game) && player.chooseUse(this.outcome, "Put " + card.getName() + " onto the battlefield tapped?", "(otherwise put it into your hand)", "To battlefield", "To hand", source, game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        } else {
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }

    public FecundGreenshellEffect copy() {
        return new FecundGreenshellEffect(this);
    }
}

