/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.WolfToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FeedThePackEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("nontoken creature");

    public FeedThePackEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "sacrifice a nontoken creature. If you do, create X 2/2 green Wolf creature tokens, where X is the sacrificed creature's toughness";
    }

    private FeedThePackEffect(FeedThePackEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeedThePackEffect copy() {
        return new FeedThePackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.choose(Outcome.PutCreatureInPlay, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && permanent.sacrifice(source, game)) {
            int toughness = permanent.getToughness().getValue();
            WolfToken token = new WolfToken();
            token.putOntoBattlefield(toughness, game, source, source.getControllerId());
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

