/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FeralDeceiverEffect
extends OneShotEffect {
    FeralDeceiverEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Reveal the top card of your library. If it's a land card, {this} gets +2/+2 and gains trample until end of turn";
    }

    private FeralDeceiverEffect(FeralDeceiverEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeralDeceiverEffect copy() {
        return new FeralDeceiverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                CardsImpl cards = new CardsImpl(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                if (card.isLand(game)) {
                    game.addEffect((ContinuousEffect)new BoostSourceEffect(2, 2, Duration.EndOfTurn), source);
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn), source);
                }
            }
            return true;
        }
        return false;
    }
}

