/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class FerventMasteryAlternativeCostEffect
extends OneShotEffect {
    private final UUID alternativeCostOriginalID;

    FerventMasteryAlternativeCostEffect(UUID alternativeCostOriginalID) {
        super(Outcome.Detriment);
        this.staticText = "if the {2}{R}{R} cost was paid, an opponent discards any number of cards, then draws that many cards.<br>";
        this.alternativeCostOriginalID = alternativeCostOriginalID;
    }

    private FerventMasteryAlternativeCostEffect(FerventMasteryAlternativeCostEffect effect) {
        super((OneShotEffect)effect);
        this.alternativeCostOriginalID = effect.alternativeCostOriginalID;
    }

    public FerventMasteryAlternativeCostEffect copy() {
        return new FerventMasteryAlternativeCostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetOpponent targetOpponent;
        if (!AlternativeCostSourceAbility.getActivatedStatus((Game)game, (Ability)source, (UUID)this.alternativeCostOriginalID, (boolean)false)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (!player.chooseTarget(Outcome.DrawCard, (Target)(targetOpponent = new TargetOpponent(true)), source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        int discarded = opponent.discard(0, Integer.MAX_VALUE, false, source, game).size();
        opponent.drawCards(discarded, source, game);
        return true;
    }
}

