/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class FesteringWoundEffect
extends OneShotEffect {
    FesteringWoundEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals X damage to that player, where X is the number of infection counters on {this}";
    }

    private FesteringWoundEffect(FesteringWoundEffect effect) {
        super((OneShotEffect)effect);
    }

    public FesteringWoundEffect copy() {
        return new FesteringWoundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID sourceId = source != null ? source.getSourceId() : null;
        int amount = game.getPermanent(sourceId).getCounters(game).getCount(CounterType.INFECTION);
        UUID id = this.getTargetPointer().getFirst(game, source);
        Player player = game.getPlayer(id);
        if (player != null) {
            player.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

