/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FickleEfreetChangeControlEffect
extends OneShotEffect {
    FickleEfreetChangeControlEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin at end of combat. If you lose the flip, an opponent gains control of {this}";
    }

    private FickleEfreetChangeControlEffect(FickleEfreetChangeControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public FickleEfreetChangeControlEffect copy() {
        return new FickleEfreetChangeControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        if (!controller.flipCoin(source, game, true)) {
            TargetOpponent target = new TargetOpponent(true);
            controller.chooseTarget(this.outcome, (Target)target, source, game);
            Player chosenOpponent = game.getPlayer(target.getFirstTarget());
            if (chosenOpponent != null) {
                game.addEffect(new GainControlTargetEffect(Duration.Custom, true, chosenOpponent.getId()).setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game)), source);
                game.informPlayers(chosenOpponent.getLogName() + " has gained control of " + sourcePermanent.getLogName());
                return true;
            }
        }
        return false;
    }
}

