/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class FiendArtisanEffect
extends OneShotEffect {
    FiendArtisanEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a creature card with mana value X or less, put it onto the battlefield, then shuffle";
    }

    private FiendArtisanEffect(FiendArtisanEffect effect) {
        super((OneShotEffect)effect);
    }

    public FiendArtisanEffect copy() {
        return new FiendArtisanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + xValue + " or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary((FilterCard)filter)).apply(game, source);
    }
}

