/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FiendlashEffect
extends OneShotEffect {
    FiendlashEffect() {
        super(Outcome.Benefit);
    }

    private FiendlashEffect(FiendlashEffect effect) {
        super((OneShotEffect)effect);
    }

    public FiendlashEffect copy() {
        return new FiendlashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanentOrLKIBattlefield((UUID)game.getState().getValue("Fiendlash" + source.getSourceId()));
        if (creature == null) {
            return false;
        }
        int damage = creature.getPower().getValue();
        if (damage < 1) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            permanent.damage(damage, creature.getId(), source, game);
            return true;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            player.damage(damage, creature.getId(), source, game);
            return true;
        }
        return false;
    }
}

