/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.f.FiendlashEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetPlayerOrPlaneswalker;

class FiendlashTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    FiendlashTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new FiendlashEffect(), false);
        this.addTarget((Target)new TargetPlayerOrPlaneswalker());
    }

    private FiendlashTriggeredAbility(FiendlashTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FiendlashTriggeredAbility copy() {
        return new FiendlashTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipment = this.getSourcePermanentIfItStillExists(game);
        if (equipment == null || !event.getTargetId().equals(equipment.getAttachedTo())) {
            return false;
        }
        game.getState().setValue("Fiendlash" + equipment.getId(), (Object)equipment.getAttachedTo());
        return true;
    }

    public String getRule() {
        return "Whenever equipped creature is dealt damage, it deals damage equal to its power to target player or planeswalker.";
    }
}

