/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class FierceInvocationEffect
extends OneShotEffect {
    public FierceInvocationEffect() {
        super(Outcome.Benefit);
        this.staticText = "Manifest the top card of your library, then put two +1/+1 counters on it.<i> (To manifest a card, put it onto the battlefield face down as a 2/2 creature. Turn it face up any time for its mana cost if it's a creature card.)</i>";
    }

    private FierceInvocationEffect(FierceInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public FierceInvocationEffect copy() {
        return new FierceInvocationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                new ManifestEffect(1).apply(game, source);
                Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                if (permanent != null) {
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(2));
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    return effect.apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

