/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreatureOrPlaneswalker;

class FieryEncoreEffect
extends OneShotEffect {
    FieryEncoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard a card, then draw a card. When you discard a nonland card this way, {this} deals damage equal to that card's mana value to target creature or planeswalker";
    }

    private FieryEncoreEffect(FieryEncoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public FieryEncoreEffect copy() {
        return new FieryEncoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discardOne(false, false, source, game);
        player.drawCards(1, source, game);
        if (card == null || card.isLand(game)) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(card.getManaValue()), false, "when you discard a nonland card this way, {this} deals damage equal to that card's mana value to target creature or planeswalker");
        ability.addTarget((Target)new TargetCreatureOrPlaneswalker());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

