/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FightingChanceEffect
extends OneShotEffect {
    FightingChanceEffect() {
        super(Outcome.Detriment);
        this.staticText = "For each blocking creature, flip a coin. If you win the flip, prevent all combat damage that would be dealt by that creature this turn.";
    }

    private FightingChanceEffect(FightingChanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public FightingChanceEffect copy() {
        return new FightingChanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (UUID blocker : game.getCombat().getBlockers()) {
                if (!player.flipCoin(source, game, true)) continue;
                PreventDamageByTargetEffect effect = new PreventDamageByTargetEffect(Duration.EndOfTurn, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(blocker, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

