/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FigureOfFableScoutEffect
extends OneShotEffect {
    FigureOfFableScoutEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Scout, it becomes a Kithkin Soldier with base power and toughness 4/5";
    }

    private FigureOfFableScoutEffect(FigureOfFableScoutEffect effect) {
        super((OneShotEffect)effect);
    }

    public FigureOfFableScoutEffect copy() {
        return new FigureOfFableScoutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.SCOUT, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.KITHKIN, SubType.SOLDIER}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(4, 5, Duration.Custom), source);
        return true;
    }
}

