/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FinalityEffect
extends OneShotEffect {
    FinalityEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put two +1/+1 counters on a creature you control. Then all creatures get -4/-4 until end of turn.";
    }

    private FinalityEffect(FinalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinalityEffect copy() {
        return new FinalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, 1);
        target.withNotTarget(true);
        if (player.choose(Outcome.BoostCreature, (Target)target, source, game)) {
            AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(2));
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        game.addEffect((ContinuousEffect)new BoostAllEffect(-4, -4, Duration.EndOfTurn), source);
        return true;
    }
}

