/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.game.Game;
import mage.target.common.TargetAnyTarget;
import mage.util.CardUtil;

class FireballTargetCreatureOrPlayer
extends TargetAnyTarget {
    public FireballTargetCreatureOrPlayer(int minNumTargets, int maxNumTargets) {
        super(minNumTargets, maxNumTargets);
    }

    private FireballTargetCreatureOrPlayer(FireballTargetCreatureOrPlayer target) {
        super((TargetAnyTarget)target);
    }

    public List<TargetAnyTarget> getTargetOptions(Ability source, Game game) {
        ArrayList<TargetAnyTarget> options = new ArrayList<TargetAnyTarget>();
        int xVal = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xVal < 1) {
            return options;
        }
        for (int numberTargets = 1; numberTargets == 1 || xVal / (numberTargets - 1) > 1; ++numberTargets) {
            Set possibleTargets = this.possibleTargets(source.getControllerId(), source, game);
            if (possibleTargets.size() < numberTargets) {
                return options;
            }
            if ((xVal - (numberTargets - 1)) / numberTargets < 1) continue;
            for (UUID targetId : possibleTargets) {
                FireballTargetCreatureOrPlayer target = this.copy();
                target.clearChosen();
                target.addTarget(targetId, source, game, true);
                if (target.getTargets().size() == numberTargets) {
                    this.chosen = true;
                }
                if (!target.isChosen(game)) {
                    Iterator it2 = possibleTargets.iterator();
                    while (it2.hasNext() && !target.isChosen(game)) {
                        UUID nextTargetId = (UUID)it2.next();
                        target.addTarget(nextTargetId, source, game, true);
                        if (target.getTargets().size() != numberTargets) continue;
                        this.chosen = true;
                    }
                }
                if (!target.isChosen(game)) continue;
                options.add(target);
            }
        }
        return options;
    }

    public FireballTargetCreatureOrPlayer copy() {
        return new FireballTargetCreatureOrPlayer(this);
    }
}

