/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class FirestormPhoenixRestrictEffect
extends ContinuousRuleModifyingEffectImpl {
    private int startingTurnNum;

    FirestormPhoenixRestrictEffect() {
        super(Duration.Custom, Outcome.Detriment);
    }

    private FirestormPhoenixRestrictEffect(FirestormPhoenixRestrictEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.startingTurnNum = effect.startingTurnNum;
    }

    public FirestormPhoenixRestrictEffect copy() {
        return new FirestormPhoenixRestrictEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.startingTurnNum = game.getTurnNum();
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getCard(this.getTargetPointer().getFirst(game, source)) == null) {
            return true;
        }
        return game.isActivePlayer(game.getOwnerId(this.getTargetPointer().getFirst(game, source))) && game.getTurnNum() > this.startingTurnNum;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card cardInHand = game.getCard(this.getTargetPointer().getFirst(game, source));
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
        if (cardInHand == null || spellAbility == null) {
            return false;
        }
        Card cardToCast = spellAbility.getCharacteristics(game);
        return cardToCast != null && cardToCast.getId().equals(cardInHand.getId());
    }
}

