/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingOrBlockingCreature;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;

class FirstComeFirstServedPredicate
implements Predicate<Permanent> {
    private static final Pattern partNumberPattern = Pattern.compile("\\d+");

    FirstComeFirstServedPredicate() {
    }

    public boolean apply(Permanent input, Game game) {
        if (input instanceof PermanentCard) {
            int lowestNumber = Integer.MAX_VALUE;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterAttackingOrBlockingCreature(), game)) {
                int number = this.parseCardNumber(permanent);
                if (number <= 0 || lowestNumber <= number) continue;
                lowestNumber = number;
            }
            return this.parseCardNumber(input) == lowestNumber;
        }
        return false;
    }

    public int parseCardNumber(Permanent input) {
        String str = input.getCardNumber();
        if (str == null || str.isEmpty()) {
            return 0;
        }
        Matcher matcher = partNumberPattern.matcher(str);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        throw new IllegalStateException("Unknown card number format [" + input.getCardNumber() + "] for permanent " + input.getName());
    }
}

