/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Iterator;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Shark33Token;
import mage.game.permanent.token.Token;

class FishersTalentLevel2Effect
extends ReplacementEffectImpl {
    FishersTalentLevel2Effect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would create a Fish token, create a 3/3 blue Shark creature token instead";
    }

    private FishersTalentLevel2Effect(FishersTalentLevel2Effect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FishersTalentLevel2Effect copy() {
        return new FishersTalentLevel2Effect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!(event instanceof CreateTokenEvent) || !event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        for (Token token : ((CreateTokenEvent)event).getTokens().keySet()) {
            if (!token.hasSubtype(SubType.FISH, game)) continue;
            return true;
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amount = 0;
        Map tokens = ((CreateTokenEvent)event).getTokens();
        Iterator iter = tokens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Token token = (Token)entry.getKey();
            if (!token.hasSubtype(SubType.FISH, game)) continue;
            amount += ((Integer)entry.getValue()).intValue();
            iter.remove();
        }
        tokens.put(new Shark33Token(), amount);
        return false;
    }
}

