/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FlamescrollCelebrantTriggeredAbility
extends TriggeredAbilityImpl {
    FlamescrollCelebrantTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)StaticValue.get((int)1), true, "that player", true));
    }

    private FlamescrollCelebrantTriggeredAbility(FlamescrollCelebrantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FlamescrollCelebrantTriggeredAbility copy() {
        return new FlamescrollCelebrantTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getOpponents(event.getPlayerId()).contains(this.getControllerId())) {
            return false;
        }
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility.getStackAbility().isManaActivatedAbility()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }

    public String getRule() {
        return "Whenever an opponent activates an ability that isn't a mana ability, {this} deals 1 damage to that player.";
    }
}

