/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SaprolingToken;
import mage.players.Player;

class FlashFoliageEffect
extends OneShotEffect {
    FlashFoliageEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 green Saproling creature token that's blocking target creature attacking you";
    }

    private FlashFoliageEffect(FlashFoliageEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlashFoliageEffect copy() {
        return new FlashFoliageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CombatGroup combatGroup;
            SaprolingToken token = new SaprolingToken();
            token.putOntoBattlefield(1, game, source, source.getControllerId());
            Permanent attackingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (attackingCreature != null && game.getState().getCombat() != null && (combatGroup = game.getState().getCombat().findGroup(attackingCreature.getId())) != null) {
                for (UUID tokenId : token.getLastAddedTokenIds()) {
                    Permanent saprolingToken = game.getPermanent(tokenId);
                    if (saprolingToken == null) continue;
                    combatGroup.addBlocker(tokenId, source.getControllerId(), game);
                    game.getCombat().addBlockingGroup(tokenId, attackingCreature.getId(), controller.getId(), game);
                }
            }
            return true;
        }
        return false;
    }
}

