/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FlayingTendrilsReplacementEffect
extends ReplacementEffectImpl {
    FlayingTendrilsReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "If a creature would die this turn, exile it instead";
    }

    private FlayingTendrilsReplacementEffect(FlayingTendrilsReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FlayingTendrilsReplacementEffect copy() {
        return new FlayingTendrilsReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && permanent != null) {
            return controller.moveCards((Card)permanent, Zone.EXILED, source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        return zce.isDiesEvent() && zce.getTarget().isCreature(game);
    }
}

