/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;

class FloodgateDamageEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private static final FilterControlledPermanent filter2 = new FilterControlledPermanent();

    public FloodgateDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals damage equal to half the number of Islands you control, rounded down, to each nonblue creature without flying";
    }

    private FloodgateDamageEffect(FloodgateDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public FloodgateDamageEffect copy() {
        return new FloodgateDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int islandCount = new PermanentsOnBattlefieldCount((FilterPermanent)filter2).calculate(game, source, (Effect)this);
        islandCount = Math.floorDiv(islandCount, 2);
        return new DamageAllEffect(islandCount, (FilterPermanent)filter).apply(game, source);
    }

    static {
        filter.add(Predicates.not((Predicate)new ColorPredicate(ObjectColor.BLUE)));
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
        filter2.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

