/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.Ownerable;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FloodpitsDrownerEffect
extends OneShotEffect {
    FloodpitsDrownerEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle {this} and target creature with a stun counter on it into their owners' libraries";
    }

    private FloodpitsDrownerEffect(FloodpitsDrownerEffect effect) {
        super((OneShotEffect)effect);
    }

    public FloodpitsDrownerEffect copy() {
        return new FloodpitsDrownerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        permanents.add(source.getSourcePermanentIfItStillExists(game));
        permanents.add(game.getPermanent(this.getTargetPointer().getFirst(game, source)));
        permanents.removeIf(Objects::isNull);
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 2: {
                if (permanents.stream().map(Ownerable::getOwnerId).distinct().count() > 1L) break;
            }
            case 1: {
                Player player = game.getPlayer(((Permanent)permanents.get(0)).getOwnerId());
                return player != null && player.shuffleCardsToLibrary((Cards)new CardsImpl(permanents), game, source);
            }
        }
        for (Permanent permanent : permanents) {
            Player player = game.getPlayer(permanent.getOwnerId());
            if (player == null) continue;
            player.shuffleCardsToLibrary((Card)permanent, game, source);
        }
        return true;
    }
}

