/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class FlowstoneSculptureEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    public FlowstoneSculptureEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put a +1/+1 counter on {this} or {this} gains flying, first strike, or trample.";
    }

    private FlowstoneSculptureEffect(FlowstoneSculptureEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlowstoneSculptureEffect copy() {
        return new FlowstoneSculptureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FlyingAbility gainedAbility;
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose ability to add");
            choice.setChoices(choices);
            if (!controller.choose(this.outcome, (Choice)choice, game)) {
                return false;
            }
            String chosen = choice.getChoice();
            if (chosen.equals("+1/+1 counter")) {
                return new AddCountersSourceEffect(CounterType.P1P1.createInstance()).apply(game, source);
            }
            switch (chosen) {
                case "Flying": {
                    gainedAbility = FlyingAbility.getInstance();
                    break;
                }
                case "First strike": {
                    gainedAbility = FirstStrikeAbility.getInstance();
                    break;
                }
                default: {
                    gainedAbility = TrampleAbility.getInstance();
                }
            }
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)gainedAbility, Duration.WhileOnBattlefield), source);
            return true;
        }
        return false;
    }

    static {
        choices.add("+1/+1 counter");
        choices.add("Flying");
        choices.add("First Strike");
        choices.add("Trample");
    }
}

