/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.LinkedHashSet;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FluctuatorEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Cycling abilities you activate cost up to {2} less to activate";

    public FluctuatorEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = effectText;
    }

    private FluctuatorEffect(FluctuatorEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isControlledBy(source.getControllerId()) && abilityToModify instanceof CyclingAbility;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            Mana mana = abilityToModify.getManaCostsToPay().getMana();
            int reduceMax = mana.getGeneric();
            if (reduceMax > 2) {
                reduceMax = 2;
            }
            if (reduceMax > 0) {
                int reduce;
                if (game.inCheckPlayableState() || controller.isComputer()) {
                    reduce = reduceMax;
                } else {
                    ChoiceImpl choice = new ChoiceImpl(true);
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (int i = 0; i <= reduceMax; ++i) {
                        set.add(String.valueOf(i));
                    }
                    choice.setChoices(set);
                    choice.setMessage("Reduce cycling cost");
                    if (controller.choose(Outcome.Benefit, (Choice)choice, game)) {
                        reduce = Integer.parseInt(choice.getChoice());
                    } else {
                        return false;
                    }
                }
                CardUtil.reduceCost((Ability)abilityToModify, (int)reduce);
            }
            return true;
        }
        return false;
    }

    public FluctuatorEffect copy() {
        return new FluctuatorEffect(this);
    }
}

