/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FluxEffect
extends OneShotEffect {
    FluxEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Each player discards any number of cards, then draws that many cards";
    }

    private FluxEffect(FluxEffect effect) {
        super((OneShotEffect)effect);
    }

    public FluxEffect copy() {
        return new FluxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int numToDiscard = player.getAmount(0, player.getHand().size(), "Discard how many cards?", source, game);
            player.discard(numToDiscard, false, false, source, game);
            player.drawCards(numToDiscard, source, game);
        }
        return true;
    }
}

