/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FollowedFootstepsEffect
extends OneShotEffect {
    FollowedFootstepsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of enchanted creature";
    }

    private FollowedFootstepsEffect(FollowedFootstepsEffect effect) {
        super((OneShotEffect)effect);
    }

    public FollowedFootstepsEffect copy() {
        return new FollowedFootstepsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target;
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment != null && (target = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo())) != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
            return effect.apply(game, source);
        }
        return false;
    }
}

