/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class FootstepsOfTheGoryoEffect
extends OneShotEffect {
    FootstepsOfTheGoryoEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return target creature card from your graveyard to the battlefield. Sacrifice that creature at the beginning of the next end step";
    }

    private FootstepsOfTheGoryoEffect(FootstepsOfTheGoryoEffect effect) {
        super((OneShotEffect)effect);
    }

    public FootstepsOfTheGoryoEffect copy() {
        return new FootstepsOfTheGoryoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent;
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("Sacrifice that creature at the beginning of next end step", source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

