/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.io.Serializable;
import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ForTheAncestorsEffect
extends OneShotEffect {
    ForTheAncestorsEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature type. Look at the top six cards of your library. You may reveal any number of cards of the chosen type from among them and put the revealed cards into your hand. Put the rest on the bottom of your library in a random order";
    }

    private ForTheAncestorsEffect(ForTheAncestorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForTheAncestorsEffect copy() {
        return new ForTheAncestorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterCard filter;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        SubType subType = SubType.byDescription((String)choice.getChoiceKey());
        if (subType != null) {
            filter = new FilterCard(choice.getChoiceKey() + " cards");
            filter.add((Predicate)subType.getPredicate());
        } else {
            filter = new FilterCard();
            filter.add((Predicate & Serializable)(input, game1) -> false);
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        player.revealCards(source, (Cards)toHand, game);
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

