/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class ForTheFamilyEffect
extends OneShotEffect {
    ForTheFamilyEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target creature gets +2/+2 until end of turn. If you control four or more creatures, that creature gets +4/+4 until end of turn instead";
    }

    private ForTheFamilyEffect(ForTheFamilyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForTheFamilyEffect copy() {
        return new ForTheFamilyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int boost = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game) >= 4 ? 4 : 2;
        game.addEffect((ContinuousEffect)new BoostTargetEffect(boost, boost), source);
        return true;
    }
}

