/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class ForbiddenCryptDrawCardReplacementEffect
extends ReplacementEffectImpl {
    ForbiddenCryptDrawCardReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If you would draw a card, return a card from your graveyard to your hand instead. If you can't, you lose the game";
    }

    private ForbiddenCryptDrawCardReplacementEffect(ForbiddenCryptDrawCardReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ForbiddenCryptDrawCardReplacementEffect copy() {
        return new ForbiddenCryptDrawCardReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            boolean cardReturned = false;
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard();
            target.withNotTarget(true);
            if (target.canChoose(controller.getId(), source, game) && target.choose(Outcome.ReturnToHand, controller.getId(), source.getSourceId(), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                controller.moveCards(card, Zone.HAND, source, game);
                cardReturned = true;
            }
            if (!cardReturned) {
                game.informPlayers(controller.getLogName() + " can't return a card from graveyard to hand.");
                controller.lost(game);
            }
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

