/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;

class ForbiddenRitualEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("a nontoken permanent");

    ForbiddenRitualEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Sacrifice a nontoken permanent. If you do, target opponent loses 2 life unless that player sacrifices a permanent or discards a card. You may repeat this process any number of times";
    }

    private ForbiddenRitualEffect(ForbiddenRitualEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForbiddenRitualEffect copy() {
        return new ForbiddenRitualEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        do {
            OrCost cost;
            Permanent permanent;
            TargetSacrifice targetSacrifice;
            if (!(targetSacrifice = new TargetSacrifice(filter)).choose(Outcome.Sacrifice, source.getControllerId(), source.getSourceId(), source, game) || (permanent = game.getPermanent(targetSacrifice.getFirstTarget())) == null || !permanent.sacrifice(source, game) || (cost = new OrCost("sacrifice a permanent or discard a card", new Cost[]{new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT), new DiscardCardCost()})).canPay(source, source, opponent.getId(), game) && opponent.chooseUse(Outcome.Sacrifice, "Sacrifice a permanent or discard a card? (Otherwise you lose 2 life.)", source, game) && cost.pay(source, game, source, opponent.getId(), true)) continue;
            opponent.loseLife(2, game, source, false);
        } while (controller.canRespond() && controller.chooseUse(Outcome.AIDontUseIt, "Repeat this process? (Sacrifice another nontoken permanent?)", source, game));
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

